/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) MAXON Computer GmbH, all rights reserved            //
/////////////////////////////////////////////////////////////

#ifndef C4D_BITMAPFILTER_H__
#define C4D_BITMAPFILTER_H__

#include "x4d_filter.h"

class BaseBitmap;

//----------------------------------------------------------------------------------------
/// @markPrivate
//----------------------------------------------------------------------------------------
BM_TILE* BfBitmapTileGet(BM_REF bm, const RECT32* src_rect, Int32 width, Int32 height, Int32 tile_mode, Int32 flags);

//----------------------------------------------------------------------------------------
/// @markPrivate
//----------------------------------------------------------------------------------------
Int32 BfBitmapTileDetach(BM_REF bm, BM_TILE* tile_buf, Int32 flags);

//----------------------------------------------------------------------------------------
/// @markPrivate
//----------------------------------------------------------------------------------------
Int32 BfDiscardChanges(BM_REF bm);

//----------------------------------------------------------------------------------------
/// @markPrivate
//----------------------------------------------------------------------------------------
Int32 BfUpdateView(BM_REF bm);

//----------------------------------------------------------------------------------------
/// @markPrivate
//----------------------------------------------------------------------------------------
Bool BfConvertTileToBasebmp(const BM_TILE* tile, const RECT32* tile_rect, BaseBitmap* bmp, Int32 zero);

//----------------------------------------------------------------------------------------
/// @markPrivate
//----------------------------------------------------------------------------------------
Bool BfBitmapTileScale(BM_REF bm, BM_TILE* src_bm, BM_TILE* dst_bm, RECT32* src_rect, RECT32* dst_rect);

//----------------------------------------------------------------------------------------
/// @markPrivate
//----------------------------------------------------------------------------------------
PROGRESS_ID BfProgressNew(BM_REF bm);

//----------------------------------------------------------------------------------------
/// @markPrivate
//----------------------------------------------------------------------------------------
Int32 BfProgressDelete(BM_REF bm, PROGRESS_ID pid);

//----------------------------------------------------------------------------------------
/// @markPrivate
//----------------------------------------------------------------------------------------
Int32 BfProgressUpdate(BM_REF bm, PROGRESS_ID pid, Int32 current_value, Int32 max_value, const String& text);

//----------------------------------------------------------------------------------------
/// @markPrivate
//----------------------------------------------------------------------------------------
BaseContainer GetGlobalFilterPrefs(Int32 pluginid);

//----------------------------------------------------------------------------------------
/// @markPrivate
//----------------------------------------------------------------------------------------
Bool SetGlobalFilterPrefs(Int32 pluginid, const BaseContainer& prefs);

//----------------------------------------------------------------------------------------
/// Retrieves @C4D's window handle (@c HWND). @markPrivate
/// @return												@C4D's window handle.
//----------------------------------------------------------------------------------------
void* GetEditorWindow(void);

//----------------------------------------------------------------------------------------
/// Checks if a window handle is one of @C4D's windows. @markPrivate
/// @param[in] win								The window handle (@c HWND) to check.
/// @return												@trueIfOtherwiseFalse{the window handle is one of @C4D's windows}
//----------------------------------------------------------------------------------------
Bool IsHostWindow(void* win);

#ifdef MAXON_TARGET_OSX
Bool Mac_hostProcessEvent(void* event);	// Mac event routing.
#endif

#endif // C4D_BITMAPFILTER_H__
